/*
 * Decompiled with CFR 0.152.
 */
package com.alrex.parcool.common.capability.impl;

import com.alrex.parcool.ParCoolConfig;
import com.alrex.parcool.client.animation.Animator;
import com.alrex.parcool.client.animation.PassiveCustomAnimation;
import com.alrex.parcool.client.animation.PlayerModelRotator;
import com.alrex.parcool.client.animation.PlayerModelTransformer;
import com.alrex.parcool.common.capability.capabilities.Capabilities;
import com.alrex.parcool.common.capability.impl.Parkourability;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.common.util.LazyOptional;

@OnlyIn(value=Dist.CLIENT)
public class Animation {
    private Animator animator = null;
    private final PassiveCustomAnimation passiveAnimation = new PassiveCustomAnimation();

    public static Animation get(Player player) {
        LazyOptional optional = player.getCapability(Capabilities.ANIMATION_CAPABILITY);
        if (!optional.isPresent()) {
            return null;
        }
        return (Animation)optional.orElseThrow(IllegalStateException::new);
    }

    public void setAnimator(Animator animator) {
        if (((Boolean)ParCoolConfig.CONFIG_CLIENT.disableAnimation.get()).booleanValue()) {
            return;
        }
        ParCoolConfig.Client config = ParCoolConfig.CONFIG_CLIENT;
        if (!((Boolean)config.canAnimate(animator.getClass()).get()).booleanValue()) {
            return;
        }
        this.animator = animator;
    }

    public boolean animatePre(Player player, PlayerModelTransformer modelTransformer) {
        if (this.animator == null) {
            return false;
        }
        Parkourability parkourability = Parkourability.get(player);
        return this.animator.animatePre(player, parkourability, modelTransformer);
    }

    public void animatePost(Player player, PlayerModelTransformer modelTransformer) {
        Parkourability parkourability = Parkourability.get(player);
        if (parkourability == null) {
            return;
        }
        if (this.animator == null) {
            this.passiveAnimation.animate(player, parkourability, modelTransformer);
            return;
        }
        this.animator.animatePost(player, parkourability, modelTransformer);
    }

    public void applyRotate(AbstractClientPlayer player, PlayerModelRotator rotator) {
        Parkourability parkourability = Parkourability.get((Player)player);
        if (parkourability == null) {
            return;
        }
        if (this.animator == null) {
            this.passiveAnimation.rotate((Player)player, parkourability, rotator);
            return;
        }
        this.animator.rotate((Player)player, parkourability, rotator);
    }

    public void cameraSetup(ViewportEvent.ComputeCameraAngles event, Player player, Parkourability parkourability) {
        if (this.animator == null) {
            return;
        }
        if (player.m_7578_() && Minecraft.m_91087_().f_91066_.m_92176_().m_90612_() && ((Boolean)ParCoolConfig.CONFIG_CLIENT.disableFPVAnimation.get()).booleanValue()) {
            return;
        }
        this.animator.onCameraSetUp(event, player, parkourability);
    }

    public void tick(Player player, Parkourability parkourability) {
        this.passiveAnimation.tick(player, parkourability);
        if (this.animator != null) {
            this.animator.tick();
            if (this.animator.shouldRemoved(player, parkourability)) {
                this.animator = null;
            }
        }
    }

    public boolean hasAnimator() {
        return this.animator != null;
    }

    public void removeAnimator() {
        this.animator = null;
    }
}

